`timescale 1ns / 1ps

module clk_div3(clk_in, reset, clk_out);
  input clk_in;
  input reset;
  output clk_out;
  
  reg [1:0] cnt, cnt1;
  reg       clk_1to3p, clk_1to3n;
  always @(posedge clk_in) begin
     if(!reset) begin
	     cnt <= 0;
		  clk_1to3p <= 0;
	  end
	  else begin
	     if(cnt == 2'b10) begin
		    cnt <= 0;
			 clk_1to3p <= clk_1to3p;
		  end
		  else begin
		    cnt <= cnt + 1; 
			 clk_1to3p <= !clk_1to3p;
		  end
	  end
  end
  
  always @(negedge clk_in) begin
     if(!reset) begin
	     cnt1 <= 0;
		  clk_1to3n <= 0;
	  end
	  else begin
	     if(cnt1 == 2'b10) begin
		    cnt1 <= 0;
			 clk_1to3n <= clk_1to3n;
		  end
		  else begin
		    cnt1 <= cnt1 + 1;
	       clk_1to3n <= !clk_1to3n;
		  end
	  end
  end

  assign clk_out = clk_1to3p | clk_1to3n;
  
endmodule
