module median(clk,reset,load,din,mult,dout,over,a3,b3,c3,a2,b2,c2,a1,b1,c1);  

input  clk;
input  reset;
input  load;      
input  [7:0]din;
input  [2:0]mult;  
output [7:0]dout;
output over;   
reg   over;
output [7:0]a1,a2,a3,b1,b2,b3,c1,c2,c3;
reg   [3:0]state;
reg   [3:0]cur_state;

reg    [10:0]img_x;
reg    [1:0]img_y;
reg    [10:0]pix;
reg    [10:0]piy;
reg    we0,we1,we2;
reg    run_edge;
reg    [10:0]addr;
reg    [7:0]wrdata;
wire   [7:0]rddata0,rddata1,rddata2;


reg    [7:0]a_max,a_mid,a_min,b_max,b_mid,b_min,c_max,c_mid,c_min;
reg    [7:0]max,mid,min,mid_mid,mid_max,mid_min;
reg    [7:0]q_max,q_mid,q_min;
reg    [7:0]d0,d1,d2,d3;
reg    sum0,sum1,sum2,sum3;
reg    [2:0]sum;
reg    [9:0]temp0;
reg    [7:0]temp;
reg    [7:0]a1,a2,a3,b1,b2,b3,c1,c2,c3;
reg    en;

parameter s0 = 4'd0,
          s1 = 4'd1,
          s2 = 4'd2,
          s3 = 4'd3, 
		  s4 = 4'd4,
		  s5 = 4'd5,
		  s6 = 4'd6 ,
		  s7 = 4'd7,
		  s8 = 4'd8, 
		  s9 = 4'd9,
		  s10 = 4'd10,
		  s11 = 4'd11,
		  s12 = 4'd12,
		  s13 = 4'd13,
		  s14 = 4'd14,
		  s15 = 4'd15;

assign  dout = temp;

always @(posedge clk or negedge reset)
begin
    if (reset == 0)
    begin 
        en <= 1;
        over <= 1'b0;
        img_x <= 11'd0;
        img_y <= 2'b00;
        we0 <= 1'b0;
        we1 <= 1'b0;
        we2 <= 1'b0;
        pix <= 11'd0;
        piy <= 2'd0;
        run_edge <= 1'b0;
        state <= s0;
        cur_state <= s0;
    end 
    else 
    begin
        if (load & en) 
        begin
            case (state)
            s0:begin
                   if(img_x < 11'd1728)  
                   begin
                       addr <= img_x;
                       state <= s0; 
                       wrdata <= din;
                       img_x <= img_x + 11'd1;
                       if (img_y == 0)
                           we0 <= 1;
                       else  if(img_y == 1)
                           we1 <= 1'b1;
                       else 
                           we2 <= 1'b1;    
                   end 
                   else 
                   begin 
                       state <=s1;
                       img_x <= 11'd0;
                       we0 <= 1'b0;
                       we1 <= 1'b0;
                       we2 <= 1'b0;
                   end
               end 
            s1:begin
                   addr <= pix;
                   pix <= pix + 11'd1; 
                   en <= 0;
                   run_edge <= 1'b1;
                   if (piy == 2'd0)
                     begin 
                       cur_state <= s0;
                       a3 <= rddata0;
                       b3 <= rddata1;
                       c3 <= rddata2;
                     end 
                   else if (piy == 2'd1)
                     begin 
                       cur_state <= s1;
                       a3 <= rddata2;
                       b3 <= rddata0;
                       c3 <= rddata1;
                     end 
                   else 
                     begin 
                       cur_state <= s2;
                       a3 <= rddata1;
                       b3 <= rddata2;
                       c3 <= rddata0;
                     end 
               end    
            endcase 
        end 
        else if (run_edge & !load)
        begin 
            case (cur_state) 
            s0:begin
                   piy <= 2'b00;
                   a1 <= a2;
                   b1 <= b2;
                   c1 <= c2;
                   a2 <= a3;
                   b2 <= b3;
                   c2 <= c3;
                   a3 <= rddata0;
                   b3 <= rddata1;
                   c3 <= rddata2;
                   cur_state <= s3;
               end 
            s1:begin
                   piy <= 2'b01;
                   a1 <= a2;
                   b1 <= b2;
                   c1 <= c2;
                   a2 <= a3;
                   b2 <= b3;
                   c2 <= c3;
                   a3 <= rddata2;
                   b3 <= rddata0;
                   c3 <= rddata1;
                   cur_state <= s3;
               end 
            s2:begin
                   piy <= 2'd2; 
                   a1 <= a2;
                   b1 <= b2;
                   c1 <= c2;
                   a2 <= a3;
                   b2 <= b3;
                   c2 <= c3;
                   a3 <= rddata1;
                   b3 <= rddata2;
                   c3 <= rddata0;
                   cur_state<= s3;
                end 
            s3:begin
                   d0 <= (b2 > a2 ) ? (b2 - a2)  : (a2 - b2);
                   d1 <= (b2 > b1 ) ? (b2 - b1)  : (b1 - b2);
                   d2 <= (b2 > b3 ) ? (b2 - b3)  : (b3 - b2);
                   d3 <= (b2 > c2 ) ? (b2 - c2)  : (c2 - b2);
                   cur_state <= s4;
                end 
            s4:begin 
                   sum0 <= (d0 > 4) ?  1'b0 : 1'b1;
                   sum1 <= (d1 > 4) ?  1'b0 : 1'b1;
                   sum2 <= (d2 > 4) ?  1'b0 : 1'b1;
                   sum3 <= (d3 > 4) ?  1'b0 : 1'b1;
                   cur_state <= s5;
               end 
            s5:begin 
                   sum <= (sum0 + sum1) + (sum2 + sum3);
                   cur_state <= s6;
               end 
            s6:begin 
                   if ( (sum > 3'd1) && (sum < 3'd4) )
                   begin 
                       //edge_out = 0;  //low edge ,and not to disposal 
                       cur_state <= s13;
                       q_mid <= b2;
                   end 
                   else 
                      //edge_out = 1;     //high  need to median
                      cur_state <= s7;
               end 
            s7:begin 
                   if (a1>a2)
                   begin 
                       a_max<=a1;
                       a_min<=a2;
                   end 
                   else 
                   begin
                       a_max<=a2;
                       a_min<=a1; 
                   end      
                   if (b1 > b2)   
                   begin
                       b_max<=b1;
                       b_min<=b2; 
                   end 
                   else 
                   begin
                       b_max<=b2;
                       b_min<=b1; 
                   end    
                   if(c1>c2)    
                   begin
                       c_max<=c1;
                       c_min<=c2; 
                   end 
                   else 
                   begin
                       c_max<=c2;
                       c_min<=c1; 
                   end   
                   cur_state<=s8;
               end 
            s8:begin 
                   if (a3>a_max)
                   begin         
                       a_max<=a3;
                       a_mid<=a_max;
                       a_min<=a_min;
                   end 
                   else 
                   begin
                       if (a3>a_min)      
                       begin 
                           a_max<=a_max;
                           a_mid<=a3;
                           a_min<=a_min;
                       end 
                       else 
                       begin 
                           a_max<=a_max;
                           a_mid<=a_min;
                           a_min<=a3;
                       end  
                   end 
                   if (b3>b_max)
                   begin         
                       b_max<=b3;
                       b_mid<=b_max;
                       b_min<=b_min;
                   end 
                   else 
                   begin
                       if(b3>b_min)      
                       begin 
                           b_max<=b_max;
                           b_mid<=b3;
                           b_min<=b_min;
                       end 
                       else 
                       begin 
                           b_max<=b_max;
                           b_mid<=b_min;
                           b_min<=b3;
                       end  
                    end 
                   if(c3>c_max)
                   begin         
                       c_max<=c3;
                       c_mid<=c_max;
                       c_min<=c_min;
                   end 
                   else 
                   begin
                       if(c3>c_min)      
                       begin 
                           c_max<=c_max;
                           c_mid<=c3;
                           c_min<=c_min;
                       end 
                       else 
                       begin 
                           c_max<=c_max;
                           c_mid<=c_min;
                           c_min<=c3;
                       end  
                    end   
                   cur_state<=s9;
               end                    
            s9:begin
                   if (a_max>b_max) 
                       max<=b_max;
                   else 
                       max<=a_max;
                   if (a_mid>b_mid)
                   begin 
                       mid_max<=a_mid;
                       mid_min<=b_mid;
                   end     
                   else 
                   begin 
                       mid_max<=b_mid;
                       mid_min<=a_mid;
                   end 
                   if (a_min>b_min)    
                       min<=a_min;
                   else 
                       min<=b_min;
                   cur_state<=s10;        
                end 
            s10:begin 
                    if (c_mid > mid_max) 
                        mid<=mid_max;
                    else 
                    begin 
                    if (c_mid<mid_min)      
                        mid<=mid_min;
                    else 
                        mid<=c_mid;
                    end
                    if (c_max>max)   
                        max<=max;
                    else 
                        max<=c_max;
                    if (c_min>min)    
                        min<=c_min;
                    else 
                        min<=min;  
                    cur_state<=s11;    
                end             
            s11:begin
                    if (max>mid) 
                    begin
                        q_max<=max;
                        q_min<=mid; 
                    end 
                    else 
                    begin 
                        q_max<=mid;
                        q_min<=max;
                    end 
                    cur_state<=s12;   
                end     
            s12:begin 
                    if (min>q_max)
                       q_mid<=q_max;
                    else 
                    begin 
                        if (min<q_min)  
                            q_mid<=q_min;
                        else 
                           q_mid<=min;   //q_mid is the mid which to replace the initial number 
                    end 
                    cur_state <= s13;
                end 
            s13:begin 
                    temp0 <= q_mid * mult;
                    cur_state <= s14;
                end 
            s14:begin 
                    over <= 1;
                    if (temp0 > 8'd255)
                        temp <= 8'd255;
                    else 
                        temp <= temp0[7:0];
                    cur_state <= s15;
                end 
            s15:begin
                    over <= 0;
                    if (pix == 11'd1728) 
                    begin
                        run_edge <= 0;
                        state <= s0;
                        en <=1;
                        pix <= 0;  
                        if (piy == 0)
                            piy = 2'd1;
                        else if (piy == 1)    
                            piy = 2'd2;
                        else 
                            piy = 2'd0;    
                        
                        if (img_y == 0)
                            img_y = 1;
                        else if (img_y == 1)    
                            img_y = 2;
                        else 
                            img_y =0;    
                    end 
                    else 
                    begin
                        pix <= pix + 2'd1;
                        if (piy == 2'd0) 
                            cur_state <= s0;
                        else if (piy == 2'd1)
                            cur_state <= 2'd1;
                        else 
                            cur_state <= 2'd2;
                        addr <= pix;
                    end 
                end 
            endcase  
        end     
    end
end 
 ram  r1(clk,we0,addr,wrdata,rddata0);
 ram  r2(clk,we1,addr,wrdata,rddata1);
 ram  r3(clk,we2,addr,wrdata,rddata2);
endmodule 

module ram(clk,we,addr,wrdata,rddata);

output  [7:0] rddata;
input [10:0] addr;
input [7:0] wrdata;
input we, clk;
reg [10:0] addr_reg;

reg [7:0] mem [1727:0];
	always @ (posedge clk) 
	begin
		if (we) mem[addr] <= wrdata;
		addr_reg <= addr;
	end
	assign rddata = mem[addr_reg];
	
endmodule 