`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: 
// 
// Create Date:    13:47:28 06/02/2009 
// Design Name: 
// Module Name:    zhongzhilvbo 
// Project Name: 
// Target Devices: 
// Tool versions: 
// Description: 
//
// Dependencies: 
//
// Revision: 
// Revision 0.01 - File Created
// Additional Comments: 
//
//////////////////////////////////////////////////////////////////////////////////
module zhongzhilvbo(
    clk_pixel, rst_n, 
	 din1, din2, din3, din4, din5, din6, din7, din8, din9, dout
    );
    input         clk_pixel;
	 input         rst_n;
    input  [7:0] 	din1, din2, din3, din4, din5, din6, din7, din8, din9;
    output [7:0]  dout;
	 
	 reg    [7:0]  dout;

    wire   d12, d13, d23;
    wire   d45, d46, d56;
    wire   d78, d79, d89;
	 
    wire   dd12, dd13, dd23;
    wire   dd45, dd46, dd56;
    wire   dd78, dd79, dd89;	 
	 
	 wire   ddd12, ddd13, ddd23;
	 
    reg [7:0]  dtm11, dtm12, dtm13, dtm21, dtm22, dtm23, dtm31, dtm32, dtm33;
	 reg [7:0]  dtm221, dtm222, dtm223;
	 
	 // First
	 always @(posedge clk_pixel) begin
	    if(!rst_n) begin
		    dtm11 <= 0;
			 dtm12 <= 0;
		    dtm13 <= 0;
			 dtm21 <= 0;
		    dtm22 <= 0;
			 dtm23 <= 0;
			 dtm31 <= 0;			 
		    dtm32 <= 0;
			 dtm33 <= 0;			 
		 end
		 else begin
		    //3һдСȽ
			 //dtm11Ϊ3ֵdtm12Ϊмֵdtm13ΪСֵ
          case({d12, d13, d23})
			    3'b000: begin
				    dtm11 <= din3;
					 dtm12 <= din2;
					 dtm13 <= din1;
				 end
				 3'b001: begin
				    dtm11 <= din2;
					 dtm12 <= din3;
					 dtm13 <= din1;				 
				 end
				 3'b011: begin
				    dtm11 <= din2;
					 dtm12 <= din1;
					 dtm13 <= din3;				 
				 end
				 3'b100: begin
				    dtm11 <= din3;
					 dtm12 <= din1;
					 dtm13 <= din2;				 
				 end	
				 3'b110: begin
				    dtm11 <= din1;
					 dtm12 <= din3;
					 dtm13 <= din2;				 
				 end	
				 3'b111: begin
				    dtm11 <= din1;
					 dtm12 <= din2;
					 dtm13 <= din3;				 
				 end	
             default: begin
				    dtm11 <= din3;
					 dtm12 <= din1;
					 dtm13 <= din2;	
             end				 
			 endcase
			 
		    //3һдСȽ
			 //dtm21Ϊ3ֵdtm22Ϊмֵdtm23ΪСֵ				 
          case({d45, d46, d56})
			    3'b000: begin
				    dtm21 <= din6;
					 dtm22 <= din5;
					 dtm23 <= din4;
				 end
				 3'b001: begin
				    dtm21 <= din5;
					 dtm22 <= din6;
					 dtm23 <= din4;				 
				 end
				 3'b011: begin
				    dtm21 <= din5;
					 dtm22 <= din4;
					 dtm23 <= din6;				 
				 end
				 3'b100: begin
				    dtm21 <= din6;
					 dtm22 <= din4;
					 dtm23 <= din5;				 
				 end	
				 3'b110: begin
				    dtm21 <= din4;
					 dtm22 <= din6;
					 dtm23 <= din5;				 
				 end	
				 3'b111: begin
				    dtm21 <= din4;
					 dtm22 <= din5;
					 dtm23 <= din6;				 
				 end	
             default: begin
				    dtm21 <= din6;
					 dtm22 <= din4;
					 dtm23 <= din5;	
             end				 
			 endcase	

		    //3һдСȽ
			 //dtm31Ϊ3ֵdtm32Ϊмֵdtm33ΪСֵ		
          case({d78, d79, d89})
			    3'b000: begin
				    dtm31 <= din9;
					 dtm32 <= din8;
					 dtm33 <= din7;
				 end
				 3'b001: begin
				    dtm31 <= din8;
					 dtm32 <= din9;
					 dtm33 <= din7;				 
				 end
				 3'b011: begin
				    dtm31 <= din8;
					 dtm32 <= din7;
					 dtm33 <= din9;				 
				 end
				 3'b100: begin
				    dtm31 <= din9;
					 dtm32 <= din7;
					 dtm33 <= din8;				 
				 end	
				 3'b110: begin
				    dtm31 <= din7;
					 dtm32 <= din9;
					 dtm33 <= din8;				 
				 end	
				 3'b111: begin
				    dtm31 <= din7;
					 dtm32 <= din8;
					 dtm33 <= din9;				 
				 end	
             default: begin
				    dtm31 <= din9;
					 dtm32 <= din7;
					 dtm33 <= din8;	
             end				 
			 endcase	
			 
		 end
	 end
	 
	  // Second
	  // еڶֱȽ
	 always @(posedge clk_pixel) begin
	    if(!rst_n) begin
          dtm221 <= 0;
          dtm222 <= 0;
          dtm223 <= 0;			 
		 end
		 else begin
		    // min
			 // 3Сֵеֵ
		    case({dd12, dd13, dd23})
			    3'b000, 3'b001: dtm221 <= dtm11;
				 3'b011, 3'b111: dtm221 <= dtm31;
				 default: dtm221 <= dtm21;
			 endcase
			 
			 //mid
			 //3мֵемֵ
			 case({dd45, dd46, dd56})
			    3'b000, 3'b111: dtm222 <= dtm22;
				 3'b001, 3'b110: dtm222 <= dtm32;
				 default: dtm222 <= dtm12;			 
			 endcase
			 
			 //max
			 //3ֵмСֵ
			 case({dd78, dd79, dd89})
			    3'b110, 3'b111: dtm223 <= dtm13;
				 3'b000, 3'b100: dtm223 <= dtm33;
				 default: dtm223 <= dtm23;					 
		    endcase
		 end
	end
		 
	//Third
	//һ֣3емֵ
	 always @(posedge clk_pixel) begin
	    if(!rst_n) begin
			 dout <= 0;
		 end
		 else begin
		    case({ddd12, ddd13, ddd23})
			    3'b000, 3'b111: dout <= dtm222;
				 3'b001, 3'b110: dout <= dtm223;
				 default: dout <= dtm221;
			 endcase
		 end
    end

	 //8λȽ
	 uutcompare8 inst_11_uutcompare8(
		.qa_gt_b(d12), 
		.a(din1), 
		.b(din2)
    );
	 
	 uutcompare8 inst_12_uutcompare8( 
		.qa_gt_b(d13), 
		.a(din1), 
		.b(din3)
    );	 

	 uutcompare8 inst_13_uutcompare8(
		.qa_gt_b(d23), 
		.a(din2), 
		.b(din3)
    );	

	 uutcompare8 inst_14_uutcompare8(
		.qa_gt_b(d45), 
		.a(din4), 
		.b(din5)
    );
	 
	 uutcompare8 inst_15_uutcompare8(
		.qa_gt_b(d46), 
		.a(din4), 
		.b(din6)
    );	 

	 uutcompare8 inst_16_uutcompare8(
		.qa_gt_b(d56), 
		.a(din5), 
		.b(din6)
    );		 

	 uutcompare8 inst_17_uutcompare8(
		.qa_gt_b(d78), 
		.a(din7), 
		.b(din8)
    );
	 
	 uutcompare8 inst_18_uutcompare8( 
		.qa_gt_b(d79), 
		.a(din7), 
		.b(din9)
    );	 

	 uutcompare8 inst_19_uutcompare8(
		.qa_gt_b(d89), 
		.a(din8), 
		.b(din9)
    );	

	 uutcompare8 inst_21_uutcompare8(
		.qa_gt_b(dd12), 
		.a(dtm11), 
		.b(dtm21)
    );
	 
	 uutcompare8 inst_22_uutcompare8( 
		.qa_gt_b(dd13), 
		.a(dtm11), 
		.b(dtm31)
    );	 

	 uutcompare8 inst_23_uutcompare8(
		.qa_gt_b(dd23), 
		.a(dtm21), 
		.b(dtm31)
    );	

	 uutcompare8 inst_24_uutcompare8(
		.qa_gt_b(dd45), 
		.a(dtm12), 
		.b(dtm22)
    );
	 
	 uutcompare8 inst_25_uutcompare8(
		.qa_gt_b(dd46), 
		.a(dtm12), 
		.b(dtm32)
    );	 

	 uutcompare8 inst_26_uutcompare8(
		.qa_gt_b(dd56), 
		.a(dtm22), 
		.b(dtm32)
    );		 

	 uutcompare8 inst_27_uutcompare8(
		.qa_gt_b(dd78), 
		.a(dtm13), 
		.b(dtm23)
    );
	 
	 uutcompare8 inst_28_uutcompare8( 
		.qa_gt_b(dd79), 
		.a(dtm13), 
		.b(dtm23)
    );	 

	 uutcompare8 inst_29_uutcompare8(
		.qa_gt_b(dd89), 
		.a(dtm23),
		.b(dtm33)
    );	
	 
	 
   uutcompare8 inst_31_uutcompare8(
		.qa_gt_b(ddd12), 
		.a(dtm221), 
		.b(dtm222)
    );
	 
	 uutcompare8 inst_32_uutcompare8( 
		.qa_gt_b(ddd13), 
		.a(dtm221), 
		.b(dtm223)
    );	 

	 uutcompare8 inst_33_uutcompare8(
		.qa_gt_b(ddd23), 
		.a(dtm222), 
		.b(dtm223)
    );	
	 
endmodule
